/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class FspLparConfigVpd {
    private String mLogicalSerial;
    private UnsignedInt16 mOsProduct = new UnsignedInt16(0);
    private UnsignedInt8 mOsVersion = new UnsignedInt8(0);
    private UnsignedInt8 mOsRelease = new UnsignedInt8(0);
    private UnsignedInt8 mOsModLevel = new UnsignedInt8(0);
    private UnsignedInt16 mOsDriver = new UnsignedInt16(0);
    private UnsignedInt16 mOsFixLevel = new UnsignedInt16(0);
    private static final String GET_LPAR_CONFIG_VPD = "GET_LPAR_CONFIG_VPD";
    private static final String SERIAL_NUMBER = "SERIAL_NUMBER";
    private static final String VERSION = "VERSION";

    public String toString() {
        String string = "logicalSerial=";
        if (this.mLogicalSerial != null) {
            string = string + this.mLogicalSerial;
        }
        StringBuffer stringBuffer = new StringBuffer("osProduct=");
        stringBuffer.append(this.mOsProduct.toString()).append(";osVersion=");
        stringBuffer.append(this.mOsVersion.toString()).append(";osRelease=");
        stringBuffer.append(this.mOsRelease.toString()).append(";osModLevel=");
        stringBuffer.append(this.mOsModLevel.toString()).append(";osDriver=");
        stringBuffer.append(this.mOsDriver.toString()).append(";osFixLevel=");
        stringBuffer.append(this.mOsFixLevel.toString());
        return string + "; " + stringBuffer.toString();
    }

    FspLparConfigVpd() {
    }

    FspLparConfigVpd getLparConfigVpdCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = fSPCmdMgr.doPhypCommand(GET_LPAR_CONFIG_VPD, new String[]{unsignedInt16.toString()});
        this.mLogicalSerial = ((String)hashtable.get(SERIAL_NUMBER)).trim();
        byte[] byArray = (byte[])hashtable.get(VERSION);
        if (byArray.length < 8) {
            return this;
        }
        this.mOsProduct = new UnsignedInt16((int)((short)(ByteUtilities.byteArrayToShort(byArray, 0) & 0xFFFF)));
        this.mOsVersion = new UnsignedInt8((short)(byArray[2] & 0xFF));
        this.mOsRelease = new UnsignedInt8((short)(byArray[3] & 0xFF));
        this.mOsModLevel = new UnsignedInt8((short)(byArray[4] >> 4 & 0xFF));
        byArray[4] = (byte)(byArray[4] & 0xF);
        this.mOsDriver = new UnsignedInt16((int)((short)(ByteUtilities.byteArrayToShort(byArray, 4) & 0xFFFF)));
        this.mOsFixLevel = new UnsignedInt16((int)((short)(ByteUtilities.byteArrayToShort(byArray, 6) & 0xFFFF)));
        return this;
    }

    public String getLogicalSerialNum() {
        return this.mLogicalSerial;
    }

    public UnsignedInt16 getOsProduct() {
        return this.mOsProduct;
    }

    public UnsignedInt8 getOsVersion() {
        return this.mOsVersion;
    }

    public UnsignedInt8 getOsRelease() {
        return this.mOsRelease;
    }

    public UnsignedInt8 getOsModLevel() {
        return this.mOsModLevel;
    }

    public UnsignedInt16 getOsDriver() {
        return this.mOsDriver;
    }

    public UnsignedInt16 getOsFixLevel() {
        return this.mOsFixLevel;
    }
}

